// Grayscale shader by daxnitro.

uniform sampler2D sampler0;
uniform sampler2D sampler1;
uniform sampler2D sampler2;

uniform float near;
uniform float far;

float getBrightness(vec4 color);
float getDepth(vec2 coord);

void applyEffect() {
	float brightness = getBrightness(gl_FragColor);
	gl_FragColor = vec4(brightness, brightness, brightness, gl_FragColor[3]);
}

void main() {
    vec4 baseColor = texture2D(sampler0, gl_TexCoord[0].st);
    
	gl_FragColor = baseColor;
	
	float depth = getDepth(gl_TexCoord[0].st);

	if (gl_FragColor[3] == 0.0) {
		gl_FragColor = gl_Fog.color;
	}

	applyEffect();	
}

float getBrightness(vec4 color) {
	return (color[0] + color[1] + color[2]) / 3.0;
}

float getDepth(vec2 coord) {
	float depth = texture2D(sampler1, coord).x;
	float depth2 = texture2D(sampler2, coord).x;
	if (depth2 < 1.0) {
		depth = depth2;
	}
	
    depth = 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
    
    return depth;
}